;   maskirq.inc, Copyright (c) 1997-1998 by Lukas Ruf,
;   Swiss Federal Institute of Technology,
;   Computer Engineering and Networks Laboratory.
;
;   TOPSY -- A Teachable Operating System.
;            Implementation of a tiny and simple
;            micro kernel for teaching purposes.
;
;   For further information, please visit http://www.tik.ee.ethz.ch/~topsy
;
;   This software is provided under the terms of the GNU General Public Licence.
;   A full copy of the GNU GPL is provided in the file COPYING found in the 
;   development root of Topsy.
;
;       This copyright notice supercedes all originally or previously used 
;       copyrights being used within the source code.
;       
;       Author: Lukas Ruf, lr@lpr.ch


;Topsy i386                                             Lukas Ruf, November 1997
;-------------------------------------------------------------------------------

; Mask_ALL_IRQ
; This sets IRQ00-0F vectors in the 8259s
; to be Int20 thru 2F.
;
; When the PICUs are initialized, all the hardware interrupts are MASKED.
; Each driver that uses a hardware interrupt(s) is responsible
; for unmasking that particular IRQ.
;
PICU1          EQU 0020h
PICU2          EQU 00A0h

Mask_ALL_IRQ    PROC    NEAR
        MOV     AL,00010001b
        OUT     PICU1+0,AL                  ;ICW1 - MASTER
        PUSH    EAX
        POP     EAX
        OUT     PICU2+0,AL                  ;ICW1 - SLAVE
        PUSH    EAX
        POP     EAX
        MOV     AL,20h
        OUT     PICU1+1,AL                  ;ICW2 - MASTER
        PUSH    EAX
        POP     EAX
        MOV     AL,28h
        OUT     PICU2+1,AL                  ;ICW2 - SLAVE
        PUSH    EAX
        POP     EAX
        MOV     AL,00000100b
        OUT     PICU1+1,AL                  ;ICW3 - MASTER
        PUSH    EAX
        POP     EAX
        MOV     AL,00000010b
        OUT     PICU2+1,AL                  ;ICW3 - SLAVE
        PUSH    EAX
        POP     EAX
        MOV     AL,00000001b
        OUT     PICU1+1,AL                  ;ICW4 - MASTER
        PUSH    EAX
        POP     EAX
        OUT     PICU2+1,AL                  ;ICW4 - SLAVE
        PUSH    EAX
        POP     EAX
        MOV     AL,11111010b                ;Masked all but cascade/timer
        OUT     PICU1+1,AL                  ;MASK - MASTER (0= Ints ON)
        PUSH    EAX
        POP     EAX
        MOV     AL,11111111b
        OUT     PICU2+1,AL                  ;MASK - SLAVE
        PUSH    EAX
        POP     EAX
        RETN
Mask_ALL_IRQ    ENDP

