;   creatgdt.inc, Copyright (c) 1997-1998 by Lukas Ruf,
;   Swiss Federal Institute of Technology,
;   Computer Engineering and Networks Laboratory.
;
;   TOPSY -- A Teachable Operating System.
;            Implementation of a tiny and simple
;            micro kernel for teaching purposes.
;
;   For further information, please visit http://www.tik.ee.ethz.ch/~topsy
;
;   This software is provided under the terms of the GNU General Public Licence.
;   A full copy of the GNU GPL is provided in the file COPYING found in the 
;   development root of Topsy.
;
;       This copyright notice supercedes all originally or previously used 
;       copyrights being used within the source code.
;       
;       Author: Lukas Ruf, lr@lpr.ch


;Topsy i386                                             Lukas Ruf, December 1997
;-------------------------------------------------------------------------------
;////
;// All Interrupts are disabled. (Reprogramming of IRQs)
;// There is no return to Real Mode Interrupts after execution of Create_GDT.
;// This Routine is executed in Real Mode as the GDT has to be initialized
;// before jumping to PM.
;////
Create_GDT      PROC NEAR

        JMP     ljGDT1

   GDT00:
        dd      0,0
   GDT01:       ; OS-Code
        dw       007Fh          ; Limit 15..0   A0000-20000 = 80000 / 1000 - 1 = 7F
        dw       0000h          ; Base  15..0
        db       0002h          ; Base  23..16
        db   MM_CODE_B5         ; see structur.inc
        db   MM_CODE_B6         ; see structur.inc
        db       0000h          ; Base  31..24
   GDT02:       ; OS-Data: Supported are 128MB !!
        dw      07FDFh          ; Limit 15..0  8000000-20000 = 7FE0000 / 1000 - 1 = 7FDF
;       dw      0007Fh          ; Limit 15..0  8000000-20000 = 7FE0000 / 1000 - 1 = 7FDF
        dw       0000h          ; Base  15..0
        db       0002h          ; Base  23..16
        db   MM_DATA_B5         ; see structur.inc
        db   MM_DATA_B6         ; see structur.inc
        db       0000h          ; Base  31..24
   GDT03:       ; Global-Data
        dw      0FFFFh          ; Limit 15..0   4GB / 1000 - 1 = FFFFF
        dw       0000h          ; Base  15..0
        db       0000h          ; Base  23..16
        db   MM_DATA_B5         ; see structur.inc
        db  (MM_DATA_B6 OR 0Fh) ; see structur.inc (set lower nibbble to 15)
        db       0000h          ; Base  31..24
   GDT04:       ; Video         !!! GRANULARITY IS BYTE !!!
        dw      00FBFh          ; Limit 15..0
        dw       8000h          ; Base  15..0
        db       000Bh          ; Base  23..16
        db   MM_DATA_B5         ; see structur.inc
        db   MM_DATA_B6_BYTE    ; see structur.inc
        db       0000h          ; Base  31..24
   GDT05:       ; GDT           !!! GRANULARITY IS BYTE !!!
        dw      0EFFFh          ; Limit 15..0
        dw       1000h          ; Base  15..0 at 2nd Page
        db       0000h          ; Base  23..16
        db   MM_DATA_B5         ; see structur.inc
        db   MM_DATA_B6_BYTE    ; see structur.inc
        db       0000h          ; Base  31..24
   ljGDT1:
        GDTxSIZE EQU ljGDT1 - GDT00

        ;Store GDT as defined above at correct location
        MOV     AX,GDTSEG
        MOV     ES,AX
        MOV     AX,GDTOFS
        MOV     DI,AX
        MOV     CX,GDTxSIZE     ; (Bytes)
        SHR     CX,1            ; (Word)
        MOV     AX,OFFSET(GDT00)
        MOV     SI,AX
        CLD
        REP     MOVSW           ; Overwrite segment.

        RET
Create_GDT      ENDP

