;   coreload.asm, Copyright (c) 1997-1998 by Lukas Ruf,
;   Swiss Federal Institute of Technology,
;   Computer Engineering and Networks Laboratory.
;
;   TOPSY -- A Teachable Operating System.
;            Implementation of a tiny and simple
;            micro kernel for teaching purposes.
;
;   For further information, please visit http://www.tik.ee.ethz.ch/~topsy
;
;   This software is provided under the terms of the GNU General Public Licence.
;   A full copy of the GNU GPL is provided in the file COPYING found in the 
;   development root of Topsy.
;
;       This copyright notice supercedes all originally or previously used 
;       copyrights being used within the source code.
;       
;       Author: Lukas Ruf, lr@lpr.ch


;Topsy i386                                                Lukas Ruf, August 1997',0Dh,0Ah
;--------------------------------------------------------------------------------',0Dh,0Ah,00h

        .model tiny
        .386p
        .code

        ORG     000h

INIT:

        jmp     START

        ;////////////////////////////////////////
        ;// Set IDT, GDT for Switching
        ;////////////////////////////////////////
        IDTptr          DW IDT_SIZE             ;LIMIT IDT Slots
                        DD IDT_BASE             ;BASE (Linear)

        GDTptr          DW GDTxSIZE             ;LIMIT GDT Slots
                        DD GDT_BASE             ;BASE (Linear) 

        INCLUDE STRUCTUR.INC
        INCLUDE CORELOAD.INC
        INCLUDE COREDISK.INC
        INCLUDE CORESCRN.INC
        INCLUDE WAITKEY.INC

        INCLUDE CORELOAD.MSG
        INCLUDE VERIFY.INC
        INCLUDE A20GATE.INC
        INCLUDE PM_SWTCH.INC
        INCLUDE RM_LOAD.INC
        INCLUDE MASKIRQ.INC
        INCLUDE CREATGDT.INC
        INCLUDE RMREBOOT.INC

START:

        PUSH    CS                      ;  Data Segment = Code Segment
        POP     DS

        MOV     AX,4*160
        MOV     XYOffs,AX

        MOV     SI,OFFSET(Message)
        PUSH    SI
        CALL    rmWrite

        CALL    Check_Processor         ; Verify min. 386

        MOV     SI, OFFSET(is386e)
        PUSH    SI
        CALL    rmWrite

        CALL    Check_Mode              ; make sure to be loaded in Real Mode

        MOV     SI,OFFSET(isreal)
        PUSH    SI
        CALL    rmWrite

        CMP     TOLODOS,1
        JE      NoDiskLoading

        ; Load Kernel
        MOV     SI,OFFSET(K_LD_MSG)
        PUSH    SI
        CALL    rmWrite
        MOV     AX,KERNOFS
        PUSH    AX
        MOV     AX,KERNSEG
        PUSH    AX
        MOV     AX,KERNTrack
        PUSH    AX
        MOV     AX,KERNHead
        PUSH    AX
        CALL    RM_LOAD

        ; Load User
        MOV     SI,OFFSET(U_LD_MSG)
        PUSH    SI
        CALL    rmWrite
        MOV     AX,USEROFS
        PUSH    AX
        MOV     AX,USERSEG
        PUSH    AX
        MOV     AX,USERTrack
        PUSH    AX
        MOV     AX,USERHead
        PUSH    AX
        CALL    RM_LOAD            ; Load Kernel from Disk and save KernelSize

        CLI                        ; Disable Interrupts

        MOV     SI, OFFSET(try_Init_A20)
        PUSH    DS
        PUSH    SI
        CALL    rmWrite

        CALL    Enable_A20         ; Turn Gate A20 on
        JC      BootPanic

        MOV     SI, OFFSET(ok_Init_A20)
        PUSH    DS
        PUSH    SI
        CALL    rmWrite

        MOV     SI,OFFSET(try_Mask_IRQ)
        PUSH    DS
        PUSH    SI
        CALL    rmWrite

        CALL    MASK_ALL_IRQ       ; Disable all IRQs

        MOV     SI,OFFSET(ok_Mask_IRQ)
        PUSH    DS
        PUSH    SI
        CALL    rmWrite

        MOV     SI,OFFSET(try_Init_GDT)
        PUSH    DS
        PUSH    SI
        CALL    rmWrite

        CALL    Create_GDT         ; Set Startup GDT

        MOV     SI,OFFSET(ok_Init_GDT)
        PUSH    DS
        PUSH    SI
        CALL    rmWrite

        MOV     SI,OFFSET(try_Init_PM)
        PUSH    DS
        PUSH    SI
        CALL    rmWrite

        CALL    PM_Switch          ; Turn Protected Mode on and jump into
                                   ; GNU-Kernel
; ///////////////////////////
; // Never Return here !!! //
; ///////////////////////////
BootPanic:
        HLT
        JMP     BootPanic

Prg_End LABEL   WORD

        END     Init

