;   a20gate.inc, Copyright (c) 1997-1998 by Lukas Ruf,
;   Swiss Federal Institute of Technology,
;   Computer Engineering and Networks Laboratory.
;
;   TOPSY -- A Teachable Operating System.
;            Implementation of a tiny and simple
;            micro kernel for teaching purposes.
;
;   For further information, please visit http://www.tik.ee.ethz.ch/~topsy
;
;   This software is provided under the terms of the GNU General Public Licence.
;   A full copy of the GNU GPL is provided in the file COPYING found in the 
;   development root of Topsy.
;
;       This copyright notice supercedes all originally or previously used 
;       copyrights being used within the source code.
;       
;       Author: Lukas Ruf, lr@lpr.ch


;Topsy i386                                            Lukas Ruf, November  1997
;-------------------------------------------------------------------------------
; Enabling Gate A20


BIT20_ON         = 0DFH                ;
BIT20_OFF        = 0DDH                ;
KBC_CTR          = 060H                ;
KBC_STAT         = 064H                ;

Enable_A20    PROC
         PUSH   AX                     ; AX sichern
         MOV    AH,BIT20_ON            ; Bit 20 am Gate bitte einschalten
         CALL   GATE_20                ; Funktion aufrufen
         OR     AL,AL                  ; Alles OK ?
         JZ     A20_OKP                ; Ja -> zum Ende
         STC                           ; Carry setzen -> Fehler
A20_OKP: POP    AX                     ; AX zurck
         RET                           ; exit
Enable_A20    ENDP

GATE_20 PROC
         CLI                           ; Interrupts ausschalten
         CALL   EMPTY_8042             ; warten, bis der Eingabepuffer leer ist
         JNZ    FAIL                   ; Fehler aufgetreten
         OUT    0EDH,AX                ;
         MOV    AL,0D1h                ; schreibe Ausgabeport
         OUT    KBC_STAT,AL            ; an Kontroller senden
         CALL   EMPTY_8042             ; warten, bis der Eingabepuffer leer ist
         JNZ    FAIL                   ; Fehler aufgetreten
         MOV    AL,AH                  ; auszugebener Wert nach AL
         OUT    KBC_CTR,AL             ; und ausgeben
         CALL   EMPTY_8042             ; warten, bis der Eingabepuffer leer ist
         PUSH   CX                     ; CX sichern
         MOV    CX,14H                 ;
DLY:     OUT    0EDH,AX                ; Warte solange, bis Kontroller fertig ist
         LOOP   DLY                    ;
         POP    CX                     ; CX zurck
FAIL:    RET                           ; zurck zum Aufrufer
GATE_20 ENDP

EMPTY_8042 PROC
         PUSH   CX                     ; CX sichern
         XOR    CX,CX                  ; lschen
TRY_KBC: OUT    0EDH,AX                ; warte-Kommando
         IN     AL,KBC_STAT            ; Status des Kontrollers lesen
         AND    AL,2                   ; testen, ob Eingabepuffer leer ist
         LOOPNZ TRY_KBC                ; solange, bis leer, oder CX = 0
         POP    CX                     ; CX zurck
         RET                           ; zurck zum Aufrufer
EMPTY_8042 ENDP


