;
;  coreboot.asm, Copyright 1997 (c) by Lukas Ruf,
;  Swiss Federal Institute of Technology,
;  Computer Engineering and Networks Laboratory.
;
;  TOPSY -- A Teachable Operating System.
;           Implementation of a tiny and simple
;           micro kernel for teaching purposes.
;
;  For further information, please visit http://www.tik.ee.ethz.ch/~topsy
;
;  This software is provided under the terms of the GNU General Public Licence.
;
;  A full copy of the GNU GPL is provided in the file COPYING found in the 
;  development root of Topsy.
;
;
;      
;      File:                  $Source: /usr/drwho/vault/cvs/topsy/Topsy/Boot/ia32/LowCore/CoreBoot/coreboot.asm,v $
;      Author(s):             Lukas Ruf
;      Affiliation:           
;      Version:               $Revision: 1.2 $
;      Creation Date:         
;      Last Date of Change:   $Date: 1999/12/13 21:48:22 $      by: $Author: ruf $
;      
;
;
;       
;       Author: Lukas Ruf, lr@lpr.ch


;Boot Core 0.15                                          Lukas Ruf, October 1997
;-------------------------------------------------------------------------------

        .model tiny
        .386
        .code

        ORG     00H
start:

        ;//
        ;// The BIOS loads us at 0:7C00H and jumps to
        ;//  location 0, where execution transfers to
        ;//  bootsect.bin forever.
        ;//

        ;//
        ;// We need a stack.  Make our stack start at 0:7C00H
        ;//  directly below where the BIOS loaded us.
        ;//

        CLD

        CLI

        MOV     AX, STACKSEG
        MOV     SS, AX
        MOV     AX, STACKTOP
        MOV     SP, AX

        STI

        MOV     AX,BOOTOFS
        SHR     AX,4
        MOV     DS,AX

        CALL    InitVideo

        CALL    rmClear                 ; Clear Screen

        MOV     SI,OFFSET(BootMsg)
        PUSH    SI
        CALL    rmWrite                 ; Say Hello

        CALL    LoadCoreLoader

        PUSH    LOADSEG                 ; Set Start location of loaded CoreLoader
        PUSH    LOADOFS
        RETF                            ; Execute loaded CoreLoader

LoadCoreLoader  PROC NEAR
        ;//
        ;// "Bootloadertrack"
        ;//

        MOV     AX,LOADSEG
        MOV     BX,LOADOFS
        MOV     DI,LOADHEAD
        MOV     DX,LOADTRACK

        PUSH    AX              ; Seg(Buff)
        PUSH    BX              ; Ofs(Buff)
        PUSH    DI              ; Head
        PUSH    DX              ; Track
        CALL    ReadTrackAtOnce

        RET

LoadCoreLoader  ENDP


        INCLUDE CORESCRN.INC
        INCLUDE CORELOAD.INC
        INCLUDE COREDISK.INC
        INCLUDE COREBOOT.MSG

        ORG     1FEH

        dw      55AAH

        END     start





