<%
  ' Questions Page
  ' Programmers: Brian Jones, Brian Crowell
  '
  ' Displays questions to user in sequential order.
  '
  ' Inputs (Questions.asp, Passage.asp)
  '   Request("qid") - Question number for the previously answered
  '       question. If this input is not supplied, the questions
  '       component is set up for the first time and the first question
  '       is displayed.
  '   Request("Answer") - Answer for the previous question, as an
  '       integer from 1 to 4.
%>
<% Option Explicit %>

<HTML>
<HEAD>
<TITLE></TITLE>
</HEAD>
<BODY>

<%
  Dim num, countervalue, PTime, record, conn, passageID, questionNum

  Set conn = Application("conn")
  Set record = Server.CreateObject("ADODB.Recordset")
  
  passageID = Session("passageID")
  
  ' Set up session variables on first runthrough
  If Request.Form("qid").Count = 0 Then			' If previous question ID not specified...
    ' Empty dictionary that keeps track of what questions we've seen/answered
    Set Session("QDictionary") = Server.CreateObject("Scripting.Dictionary")
    
    ' Store time from passage page
    Session("time") = Request.Form("time")

    DisplayQuestion(1)
  Else
    questionNum = CInt(Request.Form("qid"))
  
    ' Store answer to question #qid.
    Session("QDictionary").Add questionNum, CInt(Request.Form("Answer"))
  
    DisplayQuestion(questionNum + 1)
  End If
  

  ' DisplayQuestion( num )
  '
  ' Writes the specified question as HTML, using a form for postback
  ' data. If this question does not exist, this sub assumes that the
  ' user has completed the questions and redirects to the results page.
  '
  ' Inputs
  '   num - Number of the question to display from the current passage
  '        (Session("passageID")).
  
  Sub DisplayQuestion(num)
    record.Open "Select QuestionNum, Question, Choice1, Choice2, Choice3, Choice4 from Questions " & _
                "where QuestionNum = " & num & " and PassageID = " & passageID, conn
                
    ' Check to see if we're done; if so, display results
    If record.EOF Then
      Response.Redirect "results.asp"
    End If

    ' Have we shown this question already?
    If Session("QDictionary").Exists(num) Then
      ' Typically show an error page; this time, send back to start
      Session.Abandon
      Response.Redirect "../index.asp"
    End If
    
    Response.Write "<form action=questions.asp method=POST>"

    ' Post current question id to next page
    Response.Write "<input type=hidden name=qid value=" & num & ">"
    
    Response.Write "<p>" & num & ".&nbsp;" & record.Fields("Question").Value & "</p>"
    
    Response.Write "<p><blockquote>"
      Response.Write "<input type=radio name=Answer value=1 id=aa> <label for=aa>" & record.Fields("Choice1").Value & "</label><br>"
      Response.Write "<input type=radio name=Answer value=2 id=ab> <label for=ab>" & record.Fields("Choice2").Value & "</label><br>"
      Response.Write "<input type=radio name=Answer value=3 id=ac> <label for=ac>" & record.Fields("Choice3").Value & "</label><br>"
      Response.Write "<input type=radio name=Answer value=4 id=ad> <label for=ad>" & record.Fields("Choice4").Value & "</label><br>"
    Response.Write "</blockquote></p>"
    
    Response.Write "<input type=submit value=Continue>"
    
    Response.Write "</form>"
  
   End Sub 
%>
 </BODY>
 </HTML>