<%
  'Results page
  'Programmer: Brian Jones
  '
  'Displays results of the user's answers, number correct, and score
  '
  'Inputs (Questions.asp)
  '  Application("conn") - Used for establishing connection with the database.  
  '	 storedvalue - This will hold an alphabetic character, a through d, which 
  '		corresponds to the numerical value of the option of the choice chosen by
  '		the user when answering the questions. This is provided so the results can
  '		be displayed with alphabetic characters for convenience of the user.
  '  useranswer - This variable will store the value of the answer chosen by the user
  '		that corresponds to the current key of the question. The value will be a number 
  '		from 1 to 4.
  'Outputs (Results.asp)
  '  total - This value will count the number of questions asked during each 
  '		iteration of the For loop. 
  '  numcorrect - This value will be iterated each time the user receieves a correct answer.
  '  score - The value of score is calculated as a percentage ratio of the number correct to
  '		the total number of questions asked and is displayed at the end of the results.
%>
<% @LANGUAGE=VBScript %>

<html>
<head>
</head>
<body>
<% 
  Dim conn, record, useranswer, numcorrect, storedvalue, total
  numcorrect = 0    
  total = 0
  
  Set conn = Application("conn")
  Set record = Server.CreateObject("ADODB.Recordset")

  For Each key in Session("QDictionary")
    'iterate total (questions asked) for each iteration of the loop
    total = total + 1
    
    'this block of if-statements will allow the user to view the answers he selected
    'in the form of a letter instead of a numerical value
    If Session("QDictionary")(key) = 1 Then
      storedvalue = "a"
    End If
    If Session("QDictionary")(key) = 2 Then
      storedvalue = "b"
    End If
    If Session("QDictionary")(key) = 3 Then
      storedvalue = "c"
    End If
    If Session("QDictionary")(key) = 4 Then
      storedvalue = "d"
    End If
    
    'display the number of question and answer the user selected
    Response.Write "<p>" & key & " - " & storedvalue & "</p>"
    
    record.Open "Select QuestionNum, Answer from Questions where QuestionNum = " & key, conn
    
    'stores the value of the answer selected by the user
    useranswer = Session("QDictionary")(key)
    
    'compares the user's answer with the correct answer and displays whether correct or not
    If useranswer = record.Fields("Answer").Value Then
      Response.Write " Correct"
      numcorrect = numcorrect + 1  'count of the number of correct answers
    Else
      Response.Write " Incorrect"
    End If
    
    record.close
    
  Next
  
  'percentage calculation of the number correct divided by the total questions asked
  score = ((CDbl(numcorrect))/(CDbl(total)))*100
%>
<p>You got <%=numcorrect%> correct for a score of <%=CInt(score)%>.</p>

<p>Time: <%=Session("time")%></p>

<a href="../">Back to Main Screen</a>

</body>
</html>