<%
  'Questions Page
  'Programmer: Brian Jones
  '
  'Displays questions to user in sequential order.
  '
  'Inputs (Questions.asp, Passage.asp)
  '	 Session("passageID") - Sets the value of passageID to its session variable equivalent.
  '  Request.Form("qid") - This value will track the number of questions that have been seen or answered.
  '	 Session("time") - The value is used to store the time recorded from the passage page. This
  '			variable will be in the proper time format.
  '	 Request.Form("Answer") - This is the value given by the answer that the user selected
  '			and is stored in the Session("QDictionary") object. This value will be between
  '			1 and 4 based on which question the user selected.
  '	 questionNum - Takes the numerical value of qid to use to call the DisplayQuestion function by using
  '			a CInt function to make the proper conversion.
%>
<% Option Explicit %>

<HTML>
<HEAD>
<TITLE></TITLE>
</HEAD>
<BODY>

<%
  Dim num, countervalue, PTime, record, conn, passageID, questionNum

  Set conn = Application("conn")
  Set record = Server.CreateObject("ADODB.Recordset")
  
  passageID = Session("passageID")
  
  ' Set up session variables on first runthrough
  If Request.Form("qid").Count = 0 Then			' If previous question ID not specified...
    ' Empty dictionary that keeps track of what questions we've seen/answered
    Set Session("QDictionary") = Server.CreateObject("Scripting.Dictionary")
    
    ' Store time from passage page
    Session("time") = Request.Form("time")

    DisplayQuestion(1)
  Else
    questionNum = CInt(Request.Form("qid"))
  
    ' Store answer to question #qid.
    Session("QDictionary").Add questionNum, Request.Form("Answer")
  
    DisplayQuestion(questionNum + 1)
  End If
  
  'Inputs (Questions.asp)
  '  record.Open "..Questions.." - Selects each individual question from the values stored in
  '		the Questions record. The fields will contain a numerical value for QuestionNum which 
  '		corresponds to the number the user is answering at the time, the Question in the form
  '		of a string, and Choice# (1 through 4) in the form of a string, displayed as options to the 
  '		question using radio buttons.
  '  record.Fields("Choice#").Value - Displays each option for the individual questions in a string.
  'Outputs (Results.asp)
  '  Answer - Radio buttons provided for the user to choose the answer they wish to select.
    
  Sub DisplayQuestion(num)
    record.Open "Select QuestionNum, Question, Choice1, Choice2, Choice3, Choice4 from Questions " & _
                "where QuestionNum = " & num, conn
                
    ' Check to see if we're done; if so, display results
    If record.EOF Then
      Response.Redirect "results.asp"
    End If

    ' Have we shown this question already?
    If Session("QDictionary").Exists(num) Then
      ' Typically show an error page; this time, send back to start
      Session.Abandon
      Response.Redirect "../index.asp"
    End If
    
    Response.Write "<form action=questions.asp method=POST>"

    ' Post current question id to next page
    Response.Write "<input type=hidden name=qid value=" & num & ">"
    
    Response.Write "<p>" & num & ".&nbsp;" & record.Fields("Question").Value & "</p>"
    
    Response.Write "<p><blockquote>"
      Response.Write "<input type=radio name=Answer value=1 id=aa> <label for=aa>" & record.Fields("Choice1").Value & "</label><br>"
      Response.Write "<input type=radio name=Answer value=2 id=ab> <label for=ab>" & record.Fields("Choice2").Value & "</label><br>"
      Response.Write "<input type=radio name=Answer value=3 id=ac> <label for=ac>" & record.Fields("Choice3").Value & "</label><br>"
      Response.Write "<input type=radio name=Answer value=4 id=ad> <label for=ad>" & record.Fields("Choice4").Value & "</label><br>"
    Response.Write "</blockquote></p>"
    
    Response.Write "<input type=submit value=Continue>"
    
    Response.Write "</form>"
  
   End Sub 
%>
 </BODY>
 </HTML>