<%
  'Questions Page
  'Programmer: Brian Jones
  '
  'Displays questions to user in sequential order.
  '
  'Inputs (Questions.asp, Passage.asp)
  '  QuestionN - Checks empty Session("QDictionary") as specified
  '  	in global.asa file. Values stored in dictionary are " ". Checks for " ", 
  '		and calls QuestionNum(num) for the first question. If question has already
  '		been asked, calls the sub for the appropriate numbered question.
  '	 counter - Session("counter") is initialized to 1 in global.asa. Variable 
  '		countervalue stores the current value of Session("counter") and calls the subfunction
  '		QuestionNum(countervalue)
  '	 PTime = PTime stores the value of time taken to read the passage for later usage. 
  '		Gets the value from Passage.asp.
%>
<% Option Explicit %>

<HTML>
<HEAD>
<TITLE></TITLE>
</HEAD>
<BODY>

<%
  Dim num, countervalue, PTime, record, conn, passageID, questionNum

  Set conn = Application("conn")
  Set record = Server.CreateObject("ADODB.Recordset")
  
  passageID = Session("passageID")
  
  ' Set up session variables on first runthrough
  If Request.Form("qid").Count = 0 Then			' If previous question ID not specified...
    ' Empty dictionary that keeps track of what questions we've seen/answered
    Set Session("QDictionary") = Server.CreateObject("Scripting.Dictionary")
    
    ' Store time from passage page
    Session("time") = Request.Form("time")

    DisplayQuestion(1)
  Else
    questionNum = CInt(Request.Form("qid"))
  
    ' Store answer to question #qid.
    Session("QDictionary").Add questionNum, Request.Form("Answer")
  
    DisplayQuestion(questionNum + 1)
  End If
  
  'Inputs (Questions.asp)
  '  QuestionNum(num) - Called from previous If-Then-Else statement. Case 1 displays first 
  '     question and sets the value of the first Session("QDictionary") item to 0. 
  '  Session("counter") - counter is incremented so as to call the next question
  '  Session("QDictionary") - A check is made to determine if 0 is still stored as the
  '	    proper value in the Session("QDictionary") item.
  '	    Upon successive cases, a request is made for the previous question's
  '	    value. This value is stored in the corresponding Session("QDictionary") item.
  '  Case Else - This case will occur after counter exceeds the 10 question limit.
  ' 	This case will redirect the user to the Results.asp page.
  
  Sub DisplayQuestion(num)
    record.Open "Select QuestionNum, Question, Choice1, Choice2, Choice3, Choice4 from Questions " & _
                "where QuestionNum = " & num, conn
                
    ' Check to see if we're done; if so, display results
    If record.EOF Then
      Response.Redirect "results.asp"
    End If

    ' Have we shown this question already?
    If Session("QDictionary").Exists(num) Then
      ' Typically show an error page; this time, send back to start
      Session.Abandon
      Response.Redirect "../index.asp"
    End If
    
    Response.Write "<form action=questions.asp method=POST>"

    ' Post current question id to next page
    Response.Write "<input type=hidden name=qid value=" & num & ">"
    
    Response.Write "<p>" & num & ".&nbsp;" & record.Fields("Question").Value & "</p>"
    
    Response.Write "<p><blockquote>"
      Response.Write "<input type=radio name=Answer value=a id=aa> <label for=aa>" & record.Fields("Choice1").Value & "</label><br>"
      Response.Write "<input type=radio name=Answer value=b id=ab> <label for=ab>" & record.Fields("Choice2").Value & "</label><br>"
      Response.Write "<input type=radio name=Answer value=c id=ac> <label for=ac>" & record.Fields("Choice3").Value & "</label><br>"
      Response.Write "<input type=radio name=Answer value=d id=ad> <label for=ad>" & record.Fields("Choice4").Value & "</label><br>"
    Response.Write "</blockquote></p>"
    
    Response.Write "<input type=submit value=Continue>"
    
    Response.Write "</form>"
  
   End Sub 
%>
 </BODY>
 </HTML>