<% @LANGUAGE=VBScript %>
<% Option Explicit %>

<html>

<%
  ' Reading passage page (reading.asp)
  ' Programmer: Wayne Dunkel
  ' Date: 11-8-01
  '
  ' Presents a passage of text from a file and times the reader as he/she reads.
  '
  ' Input (from database):
  '   record.Fields("Filename").Value - Name of the file that the reading passage is in.
  '   record.Fields("PassageName").Value - Name of the passage
  '
  ' Output (to questions.asp):
  '   Request.Form("time") - Time in seconds that it took the reader to read the passage
  '
  ' History
  '   Wayne Dunkel, 11-23-01: Comments updated to reflect specifications in Software Manual
  '   Brian Crowell, 11-27-01: Accommodation for Netscape omitted as per requirements
  '   Wayne Dunkel, 11-27-01: Further documentation added, code cleaned up
%>
			
<%
	Dim filename, conn, record, passageName
	
	Set conn = Application("conn")
	Set record = Server.CreateObject("ADODB.Recordset")
	
	' retrieve values from database
	record.Open "Select PassageID, Filename, PassageName from Passages where PassageID = " & CInt(Request.QueryString("pid")), conn
   
   ' place in local variables
	filename = record.Fields("Filename").Value
	passageName = record.Fields("PassageName").Value
	
	' Store passage ID for later use
	Session("passageID") = record.Fields("PassageID").Value
	
   
   ' This function reads a file and returns a single string with line breaks replaced by "\n"
   Function ReadAllTextFile
   		Const ForReading = 1, ForWriting = 2, ForAppending = 8   
		Dim fso, f, string
		string = ""
		
		' open the file for reading
		Set fso = Server.CreateObject("Scripting.FileSystemObject")
		Set f = fso.OpenTextFile(Server.MapPath("passages/" & filename), ForReading)
		
		'read lines and replace line breaks in stream with "\n"
		While Not f.AtEndOfStream
			string = string + "\n" + f.ReadLine
		Wend
		
		f.Close
		
		ReadAllTextFile = string
	End Function 
%>

<head>
<script language="JavaScript">
<!-- Hide JavaScript from older browsers

var date, start, time, timingFlag;

time = 0;
timingFlag = 0;

// This function 'starts' the clock and displays the passage
function StartClock()
{
	if( timingFlag == 0 && time == 0 )
	{
		date = new Date();								// get time right now into new date object
		start = date.getTime();							// retrieve time in milliseconds from date object
		psgText = "<%=ReadAllTextFile%>";	
		
		document.form.Start.disabled = true;			// disable start button
		document.form.Stop.disabled = false;			// enable stop button
		document.all.IE.innerHTML = psgText;			// set passage text

		timingFlag = 1;
	}
}

// This function 'stops' the clock and hides the passage
function StopClock()
{
	if( timingFlag == 1 )
	{
		date = new Date();
		time = (date.getTime() - start) / 1000;		// get total time in seconds
		
		document.form.time.value = time;				// set time for output to another file upon submit

		document.form.Stop.disabled = true;			// disable stop button
		document.all.submit.disabled = false;			// enable submit button
		document.all.IE.innerHTML = "";				// reset passage text			

		timingFlag = 0;
	}
}

// Hide script from older browsers -->
</script>

<title>Reading Assessment - &quot;<%=passageName%>&quot;</title>
</head>

<body>

<h1 align="center"><b><font face="sans-serif">
  <font color="#FF0000">R</font>eading
  <font color="#FF0000">A</font>ssessment
</font></b></h1>

<form name="form" method="POST" action="questions.asp">
<center>
<input type="button" name="Start" onClick="StartClock()" value="Start"><br>
</center>
<br>
<input type="hidden" name="time" value="0">
<div id="IE"></div>
<br>
<br>
<center><input type="button" name="Stop" disabled="true" onclick="StopClock()" value="Stop">
<br>
<br><br>
<input type="submit" disabled="true" value="Take Quiz" name="submit">
</form>
</center>


</body>

