<%

' Create Tables Routine (create_tables_process.asp)
' Programmer: Brian Crowell
'
' Creates all user tables in the database.

Set conn = Application("conn")

' These commands were generated by the SQL Server Enterprise Manager
' Create the Questions table
conn.Execute "CREATE TABLE [dbo].[Questions] (" & _
             "    [PassageID] [int] NOT NULL ," & _
             "    [QuestionNum] [smallint] NOT NULL ," & _
             "    [Question] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ," & _
             "    [Choice1] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ," & _
             "    [Choice2] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ," & _
             "    [Choice3] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ," & _
             "    [Choice4] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ," & _
             "    [Answer] [tinyint] NOT NULL " & _
             ") ON [PRIMARY]", 0, adExecuteNoRecords Or adCmdText
             
' Create the Passages table
conn.Execute "CREATE TABLE [dbo].[Passages] (" & _
             "    [PassageID] [int] IDENTITY (1, 1) NOT NULL ," & _
             "    [Filename] [nvarchar] (20) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ," & _
             "    [PassageName] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ," & _
             "    [FogIndex] [float] NOT NULL ," & _
             "    [MeanTime] [float] NOT NULL ," & _
             "    [StdDevTime] [float] NOT NULL ," & _
             "    [MeanCorrect] [float] NOT NULL ," & _
             "    [StdDevCorrect] [float] NOT NULL ," & _
             "    [Words] [int] NOT NULL ," & _
             "    [Sentences] [int] NOT NULL " & _
             ") ON [PRIMARY]", 0, adExecuteNoRecords Or adCmdText

' Create the primary key constraint on the Questions table
conn.Execute "ALTER TABLE [dbo].[Questions] WITH NOCHECK ADD " & _
             "   CONSTRAINT [PK_Questions] PRIMARY KEY  CLUSTERED " & _
             "   (" & _
             "       [PassageID]," & _
             "       [QuestionNum]" & _
             "   )  ON [PRIMARY] ", 0, adExecuteNoRecords Or adCmdText

' Create the primary key constraint on the Passages table
conn.Execute "ALTER TABLE [dbo].[Passages] WITH NOCHECK ADD " & _
             "   CONSTRAINT [PK_Passages] PRIMARY KEY  CLUSTERED " & _
             "   (" & _
             "       [PassageID]" & _
             "   )  ON [PRIMARY] ", 0, adExecuteNoRecords Or adCmdText

' Create the foreign key constraint on the Questions table
conn.Execute "ALTER TABLE [dbo].[Questions] ADD " & _
             "   CONSTRAINT [FK_Questions_Passages] FOREIGN KEY " & _
             "   (" & _
             "       [PassageID]" & _
             "   ) REFERENCES [dbo].[Passages] (" & _
             "       [PassageID]" & _
             "   ) ON DELETE CASCADE  ON UPDATE CASCADE ", 0, adExecuteNoRecords Or adCmdText

'Response.Redirect "admin.asp"
%>
<html><head></head><body><p>Tables created.</p><p><a href="admin.asp">Return to Menu</a></p></body></html>