<% @LANGUAGE=VBScript %>
<%
  'Results page
  'Programmers: Brian Jones, Brian Crowell, Stephen Hill
  '
  'Displays results of the user's answers, number correct, and score
  '
  'Inputs
  '  Application("conn") - Used for establishing connection with the database.  
  '  Session("QDictionary") - A Dictionary object containing pairs of question
  '    numbers and answers as integers. (generated by questions.asp)
  '  Session("time") - A floating-point value containing the time it took to read
  '    the passage. (generated by questions.asp)
  '
  ' History
  '   Crowell - Added formatting (11/28/2001 version)
  '   Crowell - Ported Dr. Gregory's code for assessment (12/2/2001 version)
  '   Hill	- added in code comments to make code easier to read to the programmer
  '			- formatted code by adding returns and indents to make code more 
  '			  asthetically pleasing and easer to intrepret.
  '
  ' History
  '	   Mason - Added sentence responses to the results page (03/26/2002)
%>



<%
'---------------------------Begin Timing assessment-----------------------------
'
' AssessByTime( passageID, time, age, firstLang, yearsEng, monthsInCountry )
'
' Assesses the reading ability of the user by the length of time they took
' to read the passage. This is more or less a direct port of Dr. Gregory's
' initial code, modified to read passage statistics from the database.
'
' Inputs
'   passageID - ID number of the passage in the database. Used to recall
'       statistics specific to the passage.
'   time - Time, in seconds, that the user took to read the passage.
'   age - Approximate age of the user in years.
'   firstLang - Whether or not English is the user's primary language.
'       (zero is false, nonzero is true)
'   yearsEng - Number of years the user has studied English.
'   monthsInCountry - Number of months the user has lived in a country where
'       English is the primary language.
' Returns
'   Returns the probability that the user has a reading time problem. One is
'   high, two is mild, and three is low.
'
'	

Function AssessByTime( passageID, time, age, firstLang, yearsEng, monthsInCountry )
  			' Calibration constants
  effEng = 1			' Default English efficiency for an english-speaking person
  a1 = 1
  a2 = .4
  a3 = .05
  a4 = 5
  a5 = 4
  
  			' Read in stddev and mean times
  
  Set conn = Application("conn")
  Set record = Server.CreateObject("ADODB.Recordset")

  record.Open "Select MeanTime, StdDevTime from Passages where PassageID = " & CInt(passageID), conn
  
  meanTime = record.Fields("MeanTime").Value
  stdDevTime = record.Fields("StdDevTime").Value

  Session("meanTime") = meanTime

  		' If English is not their first language, estimate minimum language efficiency
  		' based on study time and in-country time.

  If firstLang = 0 Then
    x = yearsEng
  
    If monthsInCountry > 12 Then
      x = monthsInCountry - 12
      x = x / 12 * 4
      x = x + yearsEng
    End If
  
    effStudy = 1 - Exp(-a1 * x)                        ' Efficiency associated with study time
    effTimeInCountry = 1 - Exp(-a2 * monthsInCountry)  ' Efficiency associated time in country
  
    effEng = effStudy * effTimeInCountry
  End If
  
 		' Calculate effiency associated with age
 		
  effAge = (1 - a3*(age/25)^2 + .06) * (1 - Exp(-a4*(1 - Exp(-a5*age/25))*(age/25)^2))
  
  		' Adjust reading time for efficiencies
  		
  time = time * effEng * effAge
  
  
  		' Result code
  
  code = 3
  
  If time >= stdDevTime*2 + meanTime Then code = 2
  If time >= stdDevTime*3 + meanTime Then code = 1
  
  		' Return result code
  		
  AssessByTime = code
  
End Function
  '---------------------------------End time based assessment-----------------------------------
%>

<html>
<head>
<title>Results</title>
<style>
A.linkbutton { text-decoration: none }
A.linkbutton:hover { color: #FF0000; text-decoration: underline }
</style>
</head>

<body link="#000000" vlink="#333333">
<h1 align="center"><b><font face="sans-serif">
  <font color="#FF0000">R</font>esults
</font></b></h1>

<% 
'  -------------------------Begin Calculate score------------------------------
'
' This area of code tallies up the number of correct answers and generates
' a score. Note that this score is currently not used in the assessment
' calculations (see Dr. Gregory).
'
		'Initilize procedure
  Dim conn, record, command, useranswer, numcorrect, storedvalue, total
  numcorrect = 0    
  total = 0
  	
  Set conn = Application("conn")
  Set record = Server.CreateObject("ADODB.Recordset")
  Set command = Server.CreateObject("ADODB.Command")
  command.ActiveConnection = conn
  command.CommandType = 1 'adCmdText
%>

<table align="center" width="75%" bgcolor="#FFFFFF" cellspacing="2" cellpadding="5">
 <tr><td colspan="2"><font face="Verdana,sans-serif" size="2"><b>Questions</b></font></td></tr>
 <tr><td bgcolor="#FF0000" colspan="2"><img src="takespace.gif" height="1" width="100%"></td></tr>
<%

  For Each key in Session("QDictionary")

	    'iterate total (questions asked) for each iteration of the loop
    total = total + 1
    
	    'this block of if-statements will allow the user to view the answers he selected
	    'in the form of a letter instead of a numerical value

    If Session("QDictionary")(key) = 1 Then
      storedvalue = "a"
    End If
    If Session("QDictionary")(key) = 2 Then
      storedvalue = "b"
    End If
    If Session("QDictionary")(key) = 3 Then
      storedvalue = "c"
    End If
    If Session("QDictionary")(key) = 4 Then
      storedvalue = "d"
    End If
    
	    'display the number of question and answer the user selected

    Response.Write "<tr><td bgcolor=""#EEEEEE"" width=""75%"">"
    Response.Write "Question #" & key & ": <b>" & storedvalue & "</b>"
    Response.Write "</td><td width=""25%"">"
    
    record.Open "Select QuestionNum, Answer from Questions where QuestionNum = " & key, conn
    
	    'stores the value of the answer selected by the user

    useranswer = Session("QDictionary")(key)
    
	    'compares the user's answer with the correct answer and displays whether correct or not
   
    If useranswer = record.Fields("Answer").Value Then
      Response.Write " <b>Correct</b>"
      numcorrect = numcorrect + 1  'count of the number of correct answers
    Else
      Response.Write " <b>Incorrect</b>"
    End If
    
    Response.Write "</td></tr>"
    
    record.close
    
  Next
  
	  'percentage calculation of the number correct divided by the total questions asked
  score = ((CDbl(numcorrect))/(CDbl(total)))*100
  '  ------------------------------End Calculate Score--------------------------------
%>
</table>
<% '-------------------------------User output section-------------------------------%>

<% code = AssessByTime( 1, Session("time"), Session("age"), Session("firstLang"), Session("yearsEng"), Session("monthsInCountry") ) %>

<% 

Dim efficiency, recall 
efficiency = Session("meanTime") / Session("time")
If efficiency > 1 Then
	efficiency = 1
End If
efficiency = efficiency * 100
recall = CInt(score)

%>

<p><b>Your reading time efficiency is <%=efficiency%>%.  A value of 100% is used for average
or faster reading times.  Your reading recall percentage is <%=recall%>%.  A value of 100% is
a perfect score.</b></p>

<%If code = 3 Then%>
	<p><b>Your rate of reading expressed as efficiency is considered normal for you input information.</b></p>
<%Else%>
	<p><b>Based on your reading efficiency, it is recommended that you seek follow up professional assessment
	and determine appropriate accommodations to enhance academic performance.  Some people with similar reading
	efficiencies have been diagnosed with learning disabilities and greatly improve their academic performance
	with accommodations recommended by professionals.</b></p>
<% End If %>	
<%If recall > 65 Then%>
	<p><b>Your recall percentage is adequate for most academic work.</b></p>
<%Else%>
	<p><b>Your recall percentage is low compared to other people of your age and other input information.
	It is recommended that you review the tips for improving reading and seek professional assessment and advise.</b></p>
<% End If %>	
<p>You got <b><%=numcorrect%></b> correct for a score of <b><%=CInt(score)%></b>.</p>

<p>Reading time: <b><%=Session("time")%> seconds</b></p>

<p>Code result, based on reading time: <%=code%></p>
<% '-------------------------------End User output -----------------------------------%>

<hr>

<% 
   If Session("firstLang") = 1 Then
     Session("firstlanguage") = "English"
   Else
     Session("firstlanguage") = "Other"
   End If
%>

<% 
   command.CommandText = "INSERT into ReadStatistics VALUES ('" & Session("Age") & "','" & Session("FirstLanguage") & "','" & Session("yearsEng") & "','" & Session("monthsInCountry") & "','" & Session("Time") & "');"
   command.Execute
   set Command = Nothing
   
   '--------------------------------Wrap up------------------------------------------
	Session("didPassage") = 1 
%>

<p><font face="Verdana,sans-serif" size="2" color="#666666"><b>
  <a class="linkbutton" href="../../20020305/">Back to Main Screen</a>
</b></font></p>

</body>