<%

' Guest login process page
' Programmer: Brian Crowell (fall 2001)
				Stephen Hill (spring 2002)
'
' Interprets and stores user data as session variables. This code
' is based on the JavaScript code that generates the Guest Login
' page. (relevant passages are shown as comments)
'
' Inputs (guest_login.asp)
'   Request("AgeSelect") - Index of the selected entry
'       from the age selection box.
'   Request("AskEnglishYN") - Index of the selected entry
'       from the English-as-a-primary-language box.
'   Request("StudyEnglish") - Index of the selected entry
'       from the years of English study box.
'   Request("PrimaryLang") - Index of the selected entry
'       from the months in English-speaking country box.
'
'
'	History:Fall 2001 Team 	- created initial file
'	Stephen hill (3-25-02)  - Added more documentation to each "code segment" so the
'		 							functionality of each segment is obvious to the programmer
'								- Implemented a more aesthetically pleasing organization scheme
' 	  								including horizontal lines, spacing, and carriage returns  


'-----------------------Initilization--------------------------------
' Set session variable to indicate that the guest is logged in
Session("isLoggedIn") = True

' Determine age from age selection box, given that the box is defined as follows:
'
'agetbl[1] = "&lt; 10 "
'agetbl[2] = "10 - 15"
'agetbl[3] = "15 - 20"
'agetbl[4] = "20 - 30"
'agetbl[5] = "30 - 40"
'agetbl[6] = "40 - 50"
'agetbl[7] = "50 - 60"
'agetbl[8] = "60 - 70"
'agetbl[9] = "70 &lt; "

Select Case CInt(Request.Form("AgeSelect"))
  Case 1:
    Session("age") = 10
  Case 2:
    Session("age") = 12.5
  Case 3:
    Session("age") = 17.5
  Case 4:
    Session("age") = 25
  Case 5:
    Session("age") = 35
  Case 6:
    Session("age") = 45
  Case 7:
    Session("age") = 55
  Case 8:
    Session("age") = 65
  Case 9:
    Session("age") = 70
End Select


'English-as-a-primary-language selection box, defined as follows:
'
'englishtbl[0] = "Yes"
'englishtbl[1] = "No"

'Get english-as-a-primary-language

If Request.Form("AskEnglishYN") = "0" Then Session("firstLang") = 1 Else Session("firstLang") = 0


' Years-studying-English box, defined as follows:
'
'studyeng[0] = "Select"
'studyeng[1] = "1"
'studyeng[2] = "2"
'studyeng[3] = "3"
'studyeng[4] = "4"
'studyeng[5] = "5"
'studyeng[6] = "5 - 10"
'studyeng[7] = "10 - 15"
'studyeng[8] = "15 - 20"
'studyeng[9] = "20 &lt; "

'Get Years studying

Select Case CInt(Request.Form("StudyEnglish"))
  Case 1:
    Session("yearsEng") = 1
  Case 2:
    Session("yearsEng") = 2
  Case 3:
    Session("yearsEng") = 3
  Case 4:
    Session("yearsEng") = 4
  Case 5:
    Session("yearsEng") = 5
  Case 6:
    Session("yearsEng") = 7.5
  Case 7:
    Session("yearsEng") = 12.5
  Case 8:
    Session("yearsEng") = 17.5
  Case 9:
    Session("yearsEng") = 20
End Select


' Months-in-country-where-English-is-primary-language box, defined as follows:
'
'primarylang[0] = "Select"
'primarylang[1] = "1"
'primarylang[2] = "3"
'primarylang[3] = "6"
'primarylang[4] = "9"
'primarylang[5] = "12"
'primarylang[6] = "18"
'primarylang[7] = "24"
'primarylang[8] = "36"
'primarylang[9] = "48"
'primarylang[10] = "60 &lt; "

'Get number of months in an english speaking country

Select Case CInt(Request.Form("PrimaryLang"))
  Case 1:
    Session("monthsInCountry") = 1
  Case 2:
    Session("monthsInCountry") = 3
  Case 3:
    Session("monthsInCountry") = 6
  Case 4:
    Session("monthsInCountry") = 9
  Case 5:
    Session("monthsInCountry") = 12
  Case 6:
    Session("monthsInCountry") = 18
  Case 7:
    Session("monthsInCountry") = 24
  Case 8:
    Session("monthsInCountry") = 36
  Case 9:
    Session("monthsInCountry") = 48
  Case 10:
    Session("monthsInCountry") = 60
End Select


Response.Redirect "index.asp"

%>