<% @LANGUAGE=VBScript %>
<% Option Explicit %>

<html>

<%
  ' Reading passage page (reading.asp)
  ' Programmer: Wayne Dunkel
  ' Date: 11-8-01
  '
  ' Presents a passage of text from a file and times the reader as he/she reads.
  '
  ' Input (from database):
  '   record.Fields("Filename").Value - Name of the file that the reading passage is in.
  '   record.Fields("PassageName").Value - Name of the passage
  '
  ' Output (to questions.asp):
  '   Request.Form("time") - Time in seconds that it took the reader to read the passage
  '
  ' History
  '   Wayne Dunkel, 11-23-01: Comments updated to reflect specifications in Software Manual
  '   Brian Crowell, 11-27-01: Accommodation for Netscape omitted as per requirements
  '   Wayne Dunkel, 11-27-01: Further documentation added, code cleaned up
  '   Chris Galanos, 03-21-01:
  '			- Added more code specific documentation
  '			- Made organizational modifications to make
  '			  reading the code more aesthetically pleasing
  
%>
			
<%

'---------------------------- Beginning Initialization ----------------------------

	' Setup the variables
	
		Dim filename, conn, record, passageName
	
	' Initialize the objects
		
		Set conn = Application("conn")
		Set record = Server.CreateObject("ADODB.Recordset")
		
'----------------------------------------------------------------------------------

'------------------------------- Fill Recordset -----------------------------------
	
	' Retrieve passage values from database
		
		record.Open "Select PassageID, Filename, PassageName from Passages" & _
					" where PassageID = " & CInt(Request.QueryString("pid")), conn
   
   ' Place data in local variables
		
		filename = record.Fields("Filename").Value
		passageName = record.Fields("PassageName").Value
	
	' Store passage ID for later use
		
		Session("passageID") = record.Fields("PassageID").Value

'----------------------------------------------------------------------------------	

'---------------------------- Parse the Passage -----------------------------------
   
   ' This function reads a file and returns a single string with 
   ' line breaks replaced by "\n"
   
   Function ReadAllTextFile
   		
   		' Initialize variables
   		Const ForReading = 1, ForWriting = 2, ForAppending = 8   
		Dim fso, f, string
		string = ""
		
		' Open the file for reading
		Set fso = Server.CreateObject("Scripting.FileSystemObject")
		Set f = fso.OpenTextFile(Server.MapPath("passages/" & filename), ForReading)
		
		' Read lines and replace line breaks in stream with "\n"
		While Not f.AtEndOfStream
			string = string + "\n" + f.ReadLine
		Wend
		
		' Close the file
		f.Close
		
		' Setup variable with passage
		ReadAllTextFile = string
		
	End Function 

'----------------------------------------------------------------------------------	
%>

<head>
<script language="JavaScript">
<!-- Hide JavaScript from older browsers

//--------------------------- Beginning Initialization ----------------------------

var date, start, time, timingFlag;

time = 0;
timingFlag = 0;

//---------------------------------------------------------------------------------

//--------------------------- Start Clock Function --------------------------------

// This function 'starts' the clock and displays the passage
function StartClock()
{
	if( timingFlag == 0 && time == 0 )
	{
		date = new Date();						// get time right now into new date object
		start = date.getTime();					// retrieve time in milliseconds from date object
		psgText = "<%=ReadAllTextFile%>";	
		
		document.form.Start.disabled = true;	// disable start button
		document.form.Stop.disabled = false;	// enable stop button
		document.all.IE.innerHTML = psgText;	// set passage text

		timingFlag = 1;
	}
}

//---------------------------------------------------------------------------------

//--------------------------- Stop Clock Function ---------------------------------

// This function 'stops' the clock and hides the passage
function StopClock()
{
	if( timingFlag == 1 )
	{
		date = new Date();
		time = (date.getTime() - start) / 1000;		// get total time in seconds
		
		document.form.time.value = time;				// set time for output to another file upon submit

		document.form.Stop.disabled = true;			// disable stop button
		document.all.submit.disabled = false;			// enable submit button
		document.all.IE.innerHTML = "";				// reset passage text			

		timingFlag = 0;
	}
}

//---------------------------------------------------------------------------------

// Hide script from older browsers -->
</script>

<title>Reading Assessment - &quot;<%=passageName%>&quot;</title>
</head>

<body>

<h1 align="center"><b><font face="sans-serif">
  <font color="#FF0000">R</font>eading
  <font color="#FF0000">A</font>ssessment
</font></b></h1>

<form name="form" method="POST" action="questions.asp">
<center>
<input type="button" name="Start" onClick="StartClock()" value="Start"><br>
</center>
<br>
<input type="hidden" name="time" value="0">
<div id="IE"></div>
<br>
<br>
<center><input type="button" name="Stop" disabled="true" onclick="StopClock()" value="Stop">
<br>
<br><br>
<input type="submit" disabled="true" value="Take Quiz" name="submit">
</form>
</center>


</body>
</html>