<%
  ' Questions Page
  ' Programmers: Brian Jones (Fall 2001), Brian Crowell (Fall 2001),
  '				 Chris Galanos (Spring 2002)
  '
  ' Displays questions to user in sequential order.
  '
  ' Inputs (Questions.asp, Passage.asp)
  '   Request("qid") - Question number for the previously answered
  '       question. If this input is not supplied, the questions
  '       component is set up for the first time and the first question
  '       is displayed.
  '   Request("Answer") - Answer for the previous question, as an
  '       integer from 1 to 4.
  '
  ' History:
  ' Fall 2001 Team - created initial file
  ' Chris Galanos 03/21/02:
  '		- Added Title (Reading Assessment) to every question so that
  '       the page format isn't different from page to page.
  '		- Added more documentation to each "code segment" so the
  '		  functionality of each segment is obvious to the programmer
  '		- Implemented a more aesthetically pleasing organization scheme
  ' 	  including horizontal lines, spacing, and carriage returns  
%>

<% Option Explicit %>

<HTML>
<HEAD>
<TITLE></TITLE>
</HEAD>
<BODY>

<p align="center"><b><font face="sans-serif" size="6">
  <font color="#FF0000">R</font>eading
  <font color="#FF0000">A</font>ssessment</font></b></p>

<%

'---------------------------- Beginning Initialization ----------------------------
  
  'Setup the variables
  
  		Dim num, countervalue, PTime, record, conn, passageID, questionNum

  'Initialize the connection -- Application("conn") setup in ..\..\global.asa
  
  		Set conn = Application("conn")
  
  'Initialize the recordset used for retrieval of questions for a specific passage
  
  		Set record = Server.CreateObject("ADODB.Recordset")
  
  'Setup the local variable passageID with the Session variable
  'so that the external variables are not queried every time.
   
   		passageID = Session("passageID")
  
'----------------------------------------------------------------------------------
  
'------------------------------ First Instantiation -------------------------------

  
  	' Set up session variables on first runthrough
  	
  	' If previous question ID not specified...
  	If Request.Form("qid").Count = 0 Then			
    
    	' Empty dictionary that keeps track of what questions we've seen/answered
    	Set Session("QDictionary") = Server.CreateObject("Scripting.Dictionary")
    
    	' Store time from passage page
    	Session("time") = Request.Form("time")

		' Display first question
    	DisplayQuestion(1)
    	
	' previous question ID is specified...  
  	Else
    	
    	' Get question number passed from previous page
    	questionNum = CInt(Request.Form("qid"))
  
    	' Store answer to question #qid.
    	Session("QDictionary").Add questionNum, CInt(Request.Form("Answer"))
  
    	' Display next question
    	DisplayQuestion(questionNum + 1)
  
  	End If
 
'----------------------------------------------------------------------------------
 
'------------------------------- Display Question ---------------------------------

  ' DisplayQuestion( num )
  '
  ' Writes the specified question as HTML, using a form for postback
  ' data. If this question does not exist, this sub assumes that the
  ' user has completed the questions and redirects to the results page.
  '
  ' Inputs
  '   num - Number of the question to display from the current passage
  '        (Session("passageID")).
  
  Sub DisplayQuestion(num)
    
    'Fill the recordset with data from the SQL statement below
    record.Open "Select QuestionNum, Question, Choice1, Choice2, Choice3, Choice4 from Questions " & _
                "where QuestionNum = " & num & " and PassageID = " & passageID, conn
                
    ' Check to see if we're done; if so, display results
    If record.EOF Then
      Response.Redirect "results.asp"
    End If

    ' Have we shown this question already?
    If Session("QDictionary").Exists(num) Then
      ' Typically show an error page; this time, send back to start
      Session.Abandon
      Response.Redirect "../index.asp"
    End If
    
    Response.Write "<form action=questions.asp method=POST>"

    ' Post current question id to next page
    Response.Write "<input type=hidden name=qid value=" & num & ">"  
    Response.Write "<p>" & num & ".&nbsp;" & record.Fields("Question").Value & "</p>"
    
    ' Print out the radio buttons
    Response.Write "<p><blockquote>"
      Response.Write "<input type=radio name=Answer value=1 id=aa> <label for=aa>" & record.Fields("Choice1").Value & "</label><br>"
      Response.Write "<input type=radio name=Answer value=2 id=ab> <label for=ab>" & record.Fields("Choice2").Value & "</label><br>"
      Response.Write "<input type=radio name=Answer value=3 id=ac> <label for=ac>" & record.Fields("Choice3").Value & "</label><br>"
      Response.Write "<input type=radio name=Answer value=4 id=ad> <label for=ad>" & record.Fields("Choice4").Value & "</label><br>"
    Response.Write "</blockquote></p>"
    
    ' Print out the continue button
    Response.Write "<input type=submit value=Continue>"     
    Response.Write "</form>"

   End Sub 
   
'----------------------------------------------------------------------------------
%>

 </BODY>
 </HTML>