;;; Copyright (C) 1989 R. Kent Dybvig
;;; Permission is granted to copy and legally redistribute all or part of
;;; this code and to use it for any legal noncommercial purpose so long as
;;; this notice accompanies any copy of the code or part thereof.

;;; PCScheme/MacScheme "macro" defined in terms of "syntax-case":

(define-syntax macro
  (lambda (x)
    (syntax-case x ()
      ((_ name fcn)
       #'(define-syntax name
           (lambda (x)
             (syntax-case x ()
               ((k . stuff)
                (datum->syntax-object #'k
                  (fcn (syntax-object->datum x)))))))))))


;;; PCScheme/MacScheme "macro" defined in terms of "extend-syntax":
;;; requires (current-expand eps-expand)

;(extend-syntax (macro)
;   [(macro name fcn)
;    (eval-when (compile load eval)
;       (let ([f fcn])
;          (extend-syntax (name)
;             [anything
;              ((with ([w 'with]) w)
;               ([v (f 'anything)]) v)])))])

;;; The strange expression "(with ([w 'with]) w)" is used to insert the
;;; keyword "with" into the expansion.  The "eval-when" in the expansion is
;;; necessary to allow macros defined in a file to be used later in the
;;; file, even if the file is compiled with "compile-file".  If it were
;;; left out, the implicit "eval-when" wrapped around the "extend-syntax"
;;; would cause it to be evaluated, but without the enclosing "let"
;;; expression.  The enclosing "let" expression is necessary to cause the
;;; function to be evaluated once, which may be important if the function
;;; something other than a simple lambda expression.


;;; PCScheme/MacScheme "macro" defined in terms of "define-syntax-expander":
;;; requires (current-expand eps-expand)

;(extend-syntax (macro)
;   [(macro name fcn)
;    (define-syntax-expander name
;       (let ([f fcn])
;          (lambda (x e) (e (f x) e))))])

;;; The "eval-when" is not necessary because "define-syntax-expander"
;;; expands into an "eval-when" expression, and the "let" expression is
;;; tucked inside the "define-syntax-expander" expression.

;;; If you want to see the expander generated by either of the above
;;; "extend-syntax" definitions looks like, use "extend-syntax/code" in
;;; place of "extend-syntax":

;;; > (extend-syntax/code (macro)
;;;      [(macro name fcn)
;;;       (define-syntax-expander name
;;;          (let ([f fcn])
;;;             (lambda (x e) (e (f x) e))))])
;;;
;;; (lambda (x e)
;;;    (unless (procedure? e)
;;;       (error 'macro "~s is not a procedure" e))
;;;    (e (cond
;;;          [(syntax-match? '(macro * *) x)
;;;           `(define-syntax-expander ,(cadr x)
;;;               (let ([f ,@(cddr x)]) (lambda (x e) (e (f x) e))))]
;;;          [else (error 'macro "invalid syntax ~s" x)])
;;;       e))
